/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.GridDrawable;
import com.roguewave.chart.standard.v2_1.parts.Spacer;
import java.awt.Color;

public class NumericGrid
implements Customizer {
    private static final double defaultTopOverrunTolerance = 0.25;
    double lineIncrement_;
    double xMin_;
    double xMax_;
    double yMin_;
    double yMax_;
    Transform3D trans_;
    double lowLine_;
    double width_;
    boolean fixedWidth_;

    public NumericGrid(double lowLine, double lineIncrement, Transform3D transform) {
        this.lowLine_ = lowLine;
        this.lineIncrement_ = lineIncrement;
        this.trans_ = transform;
        this.width_ = 0.0;
        this.fixedWidth_ = false;
    }

    public NumericGrid(double lowLine, double lineIncrement, double width, Transform3D transform) {
        this.lowLine_ = lowLine;
        this.lineIncrement_ = lineIncrement;
        this.trans_ = transform;
        this.width_ = width;
        this.fixedWidth_ = true;
    }

    public Drawable getDrawable(ChartProperties properties, DataModel data) {
        double width = this.fixedWidth_ ? this.width_ : (double)data.getColumnCount();
        this.xMax_ = width / 2.0;
        this.xMin_ = -this.xMax_;
        this.yMin_ = 0.0;
        this.yMax_ = properties.getDataRangeHigh();
        Spacer spacer = new Spacer(properties, this.lowLine_, this.lineIncrement_);
        int numLines = spacer.valueCount();
        Line3D[] gridLines = new Line3D[numLines + 3];
        this.yMax_ = properties.scaleY(spacer.getValue(numLines - 1));
        gridLines[0] = new Line3D(new Point3D(this.xMin_, this.yMin_, 0.0), new Point3D(this.xMin_, this.yMax_, 0.0)).transform(this.trans_);
        gridLines[1] = new Line3D(new Point3D(this.xMax_, this.yMax_, 0.0), new Point3D(this.xMax_, this.yMin_, 0.0)).transform(this.trans_);
        gridLines[2] = new Line3D(new Point3D(this.xMin_, this.yMin_, 0.0), new Point3D(this.xMax_, this.yMin_, 0.0)).transform(this.trans_);
        for (int i = 0; i < numLines; ++i) {
            double y = properties.scaleY(spacer.getValue(i));
            gridLines[i + 3] = new Line3D(new Point3D(this.xMin_, y, 0.0), new Point3D(this.xMax_, y, 0.0)).transform(this.trans_);
        }
        Color gridColor = (Color)properties.getProperty("GridColor", Color.black);
        return new GridDrawable(gridLines, gridColor);
    }

    public Point3D[] getGridBounds() {
        Point3D[] bounds = new Point3D[]{this.trans_.transform(new Point3D(this.xMin_, this.yMin_, 0.0)), this.trans_.transform(new Point3D(this.xMin_, this.yMax_, 0.0)), this.trans_.transform(new Point3D(this.xMax_, this.yMax_, 0.0)), this.trans_.transform(new Point3D(this.xMax_, this.yMin_, 0.0))};
        return bounds;
    }
}

